\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Bine este cuvântat"
  subtitle = "glasul 1"
  %subsubtitle = "glasurile 8, 1"
  composer =  "arm. după N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOff
  \time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Bi -- ne es -- te cu -- vân -- tat Cel ce vi -- ne
  în -- tru nu -- me -- le Dom -- nu -- lui.

  Dumn -- ne -- zeu es -- te Dom -- nul
  şi s-a a -- ră -- tat __ no -- uă!
}

menWords = \womenWords

sopMusic = \relative c'' {
  a4^\mf^\accent g g g f f g2 f4 g b^\accent a g g
  f4( e) f g f e d2 \breathe d4 e f2 e4 f g2
  g2 c,4 c d e f( g) e( f) d2
  \bar "|."
}

altMusic = \relative c'' {
  a4 g g g f f g2 f4 g g f g g
  f4( e) f g f e d2 d4 e f2 e4 f g2
  e2 c4 c d e f( g) e( f) d2  
}

bassMusic = \relative c' {
  a4 g g g f f g2 f4 e d d d d
  d2 d4 d a a d2 d4 c f2 e4 d c2
  c2 c4 c c c c( c) c2 d
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 50
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}